<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');
$routes->get('/databasetest', 'DatabaseTest::index');
// user management
$routes->post('api/login', 'AuthController::login');
$routes->post('api/users', 'UserController::addUser');
$routes->put('api/users/(:num)', 'UserController::editUser/$1');

$routes->get('api/users/(:num)', 'UserController::getUserById/$1');
$routes->get('api/allusers', 'UserController::getUserList');

$routes->get('api/users/search', 'UserController::search');
$routes->post('api/logout', 'UserController::logout');

// India Mart
$routes->get('api/fetch-indiamart-leads', 'IndiaMartApi::fetchIndiaMartLeads');

// forgot password
$routes->post('api/forgot/send-otp', 'ForgotPassword::sendOtp');
$routes->post('api/forgot/verify-otp', 'ForgotPassword::verifyOtp');
$routes->post('api/forgot/reset-password', 'ForgotPassword::resetPassword');