<?php

namespace App\Controllers;

use App\Models\UserModel;
use CodeIgniter\RESTful\ResourceController;


//require_once APPPATH . 'Helpers/JwtHelper.php';
//helper('JwtHelper');

// if (function_exists('generateJWT')) {
//     echo "JWT Helper Loaded Successfully!";
// } else {
//     echo "Failed to Load JWT Helper!";
// }
// exit;
class AuthController extends ResourceController
{
    public function login()
    {
       
        $model = new UserModel();
        $email = $this->request->getVar('email');
        $password = $this->request->getVar('password');

        $user = $model->where('email', $email)->first();
          // Check if user is active
        
        // if (!$user || !password_verify($password, $user['password'])) {
        //     return $this->failUnauthorized("Invalid credentials");
        // }

        // if ($user['user_status'] != 1) {
        //     return $this->failUnauthorized("Your account is inactive. Please contact support.");
        // }
        if (!$user) {
            return $this->respond([
                'status' => 0,
                'message' => "Invalid credentials",
            ], 200); // Return 200 OK instead of 401
        }
    
        // Verify Password
        if (!password_verify($password, $user['password'])) {
            return $this->respond([
                'status' => 0,
                'message' => "Invalid credentials",
            ], 200); // Return 200 OK instead of 401
        }
    
        // Check if user is active
        if ($user['user_status'] != 1) {
            return $this->respond([
                'status' => 0,
                'message' => "Your account is inactive. Please contact support.",
            ], 200);
        }
        $token = generateJWT($user);

       // return $this->respond(['message' => 'Login successful', 'token' => $token]);
        return $this->respond([
            'status' => 1, 
            'message' => 'Login successful',
            'token' => $token,
            'data' => $user
        ]);
    }
}
