<?php 

namespace App\Controllers;

use App\Models\UserModel;
use CodeIgniter\API\ResponseTrait;

use Twilio\Rest\Client;

class ForgotPassword extends BaseApiController
{
    use ResponseTrait;

    public function sendOtp()
    {

        require_once(APPPATH.'vendor/twilio/autoload.php'); 

        $postData = $this->request->getJSON(true);
        $phone = $postData['phone'] ?? null;
        log_message('error', 'phone: ' . $phone);
        $userModel = new UserModel();
        $user = $userModel->where('phone', $phone)->first();

        log_message('error', 'User Data: ' . print_r($user, true));
        
        if (!$phone) {
            return $this->fail([
                'status' => 0,
                'message' => 'phone is required',
                'data' => null
            ], 200);
            
        }

        if (!$user) {
            return $this->failNotFound([
                'status' => 0,
                'message' => 'User not found',
                'data' => null
            ], 200);
            
        }

        // Generate OTP
        $otp = rand(100000, 999999);
        $expiry = date('Y-m-d H:i:s', strtotime('+10 minutes'));

        log_message('error', 'Generated OTP: ' . $otp);
        log_message('error', 'OTP Expiry: ' . $expiry);

        // Save to DB
        // $userModel->update($user['userid'], [
        //     'reset_otp' => $otp,
        //     'otp_expires_at' => $expiry
        // ]);

       // ✅ Send OTP via Twilio SMS
    $sid    = 'ACe5aad2cf26720556e1fb771d6a77c1d4'; // your Twilio SID
    $token  = '094852ab0a658ab9f6488d19f1ebcae1'; // your Twilio Auth Token
    $twilio_number = '+13132546496'; // your Twilio number (must start with +)

    log_message('error', 'sid: ' . $sid);
    log_message('error', 'token: ' . $token);
    log_message('error', 'twilio_number: ' . $twilio_number);
     
    

    try {
        
        
      //  $client = new Client($sid, $token);
        
       // $client->setCurlOption(CURLOPT_SSL_VERIFYPEER, false);

        $client = new Client($sid, $token);
        // $client->setHttpClient(new \Twilio\Http\CurlClient([
        //     'verify' => false
        // ]));
        
       // Assuming you have user's mobile in `mobile` column (with country code or just number)
        $mobile = $user['phone']; // for example: 9876543210
        $mobileWithCode = '+91' . $mobile; // add country code if not present
       log_message('error', 'mobile: ' . $mobileWithCode);
        
        $message = $client->messages->create($mobileWithCode, [
            'from' => $twilio_number,
            'body' => "Your OTP is $otp. It is valid for 10 minutes."
        ]);

        return $this->respond([
            'status' => 1,
            'message' => 'OTP sent successfully via SMS',
            'otp' => $otp // for testing, remove in production
        ]);
            } catch (\Exception $e) {
            log_message('error', 'Twilio SMS error: ' . $e->getMessage());

            return $this->fail([
                'status' => 0,
                'message' => 'Failed to send OTP via SMS. ' . $e->getMessage(),
            ]);
        }
    }

    public function verifyOtp()
    {
        $email = $this->request->getPost('email');
        $otp = $this->request->getPost('otp');

        $userModel = new UserModel();
        $user = $userModel->where('email', $email)->first();

        if (!$user || $user['reset_otp'] !== $otp) {
            return $this->fail('Invalid OTP');
        }

        if (strtotime($user['otp_expires_at']) < time()) {
            return $this->fail('OTP expired');
        }

        return $this->respond(['message' => 'OTP verified']);
    }

    public function resetPassword()
    {
        $email = $this->request->getPost('email');
        $otp = $this->request->getPost('otp');
        $newPassword = $this->request->getPost('password');

        $userModel = new UserModel();
        $user = $userModel->where('email', $email)->first();

        if (!$user || $user['reset_otp'] !== $otp) {
            return $this->fail('Invalid OTP');
        }

        if (strtotime($user['otp_expires_at']) < time()) {
            return $this->fail('OTP expired');
        }

        // Reset password
        $userModel->update($user['id'], [
            'password' => password_hash($newPassword, PASSWORD_DEFAULT),
            'reset_otp' => null,
            'otp_expires_at' => null
        ]);

        return $this->respond(['message' => 'Password reset successful']);
    }
}
