<?php 

// namespace App\Controllers;
// //use App\Models\LeadModel;
// use CodeIgniter\HTTP\ResponseInterface;

// class IndiaMartApi extends BaseApiController
// {
//     public function fetchIndiaMartLeads()
//     {
//         $decoded = $this->validateToken();
//         if ($decoded instanceof \CodeIgniter\HTTP\Response) {
//             return $decoded;
//         }

//         $authKey = 'mRy3FrBo4HrJSfev4n2I7liLpVvCmjZm';
//         // $url = "https://mapi.indiamart.com/wservce/enquiry/listingPOST/leads/?glusr_crm_key=$authKey";

//         $curl = \Config\Services::curlrequest();
//         // //$response = $curl->get($url);

//         // $response = $curl->get($url, [
//         //     'verify' => false
//         // ]);

//         $url = "https://mapi.indiamart.com/wservce/enquiry/listingPOST/leads/";
// $params = ['glusr_crm_key' => $authKey];
// $response = $curl->get($url, ['query' => $params, 'verify' => false]);
// log_message('error', 'indiamart: ' . $response);
//         $json = json_decode($response->getBody(), true);

//         if (!$json || empty($json['RESPONSE'])) {
//             return $this->fail("No leads found or error in fetching", 400);
//         }

//         $model = new LeadModel();
//         $leads = [];

//         foreach ($json['RESPONSE'] as $lead) {
//             $data = [
//                 'sender_name' => $lead['SENDERNAME'] ?? '',
//                 'sender_email' => $lead['SENDEREMAIL'] ?? '',
//                 'sender_mobile' => $lead['SENDER_MOBILE'] ?? '',
//                 'query' => $lead['QUERY'] ?? '',
//                 'requirement_type' => $lead['ENQ_MESSAGE_TYPE'] ?? '',
//                 'lead_source' => 'IndiaMART',
//                 'lead_date' => date('Y-m-d H:i:s', strtotime($lead['DATE_TIME'] ?? 'now')),
//             ];

//             // Optional: Save only new leads
//             $existing = $model->where('sender_mobile', $data['sender_mobile'])->first();
//             if (!$existing) {
//                 $model->insert($data);
//                 $leads[] = $data;
//             }
//         }

//         return $this->respond([
//             'status' => 1,
//             'message' => 'IndiaMART leads fetched successfully',
//             'data' => $leads
//         ]);
//     }
// }


// nEWWWWW cODDEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE



namespace App\Controllers;

use App\Libraries\TwilioService;
use App\Models\IndiaMartApiModel;
use CodeIgniter\HTTP\ResponseInterface;


class IndiaMartApi extends BaseApiController
{
    public function fetchIndiaMartLeads()
    {
        
        $decoded = $this->validateToken();
        if ($decoded instanceof \CodeIgniter\HTTP\Response) {
            return $decoded;
        }

        
        // auth key fetch through .env file 
        $authKey = trim(env('INDIAMART_API_KEY'));
        
        $url = 'https://mapi.indiamart.com/wservce/crm/crmListing/v2/';
        $params = [
            'glusr_crm_key' => $authKey,
            'start_time'    => date('d-M-Y', strtotime('-7 days')),
            'end_time'      => date('d-M-Y')
        ];


        
        $fullUrl = $url . '?' . http_build_query($params);


log_message('debug', 'IndiaMART API URL: ' . $fullUrl);


        // 4. Send GET request
        $curl = \Config\Services::curlrequest();
        try {
            $response = $curl->get($url, [
                'query' => $params,
                'verify' => false
            ]);
        } catch (\Exception $e) {
            return $this->fail("Curl error: " . $e->getMessage(), 500);
        }

        // 5. Decode the response
        $json = json_decode($response->getBody(), true);
        //log_message('debug', 'IndiaMART API raw response: ' . $response->getBody());
        
        // 6. Handle authentication failure or empty response
        if (!$json || ($json['STATUS'] ?? '') === 'FAILURE') {
            return $this->fail([
                'message' => $json['MESSAGE'] ?? 'No leads found or invalid response',
                'code'    => $json['CODE'] ?? 'Unknown',
                'status'  => $json['STATUS'] ?? 'Unknown'
            ], 401);
        }

        // 7. Parse and store leads
        $model = new IndiaMartApiModel();
        $leads = [];
        $smsService = new TwilioService(); // initialize once
        foreach ($json['RESPONSE'] as $index => $lead) {
            $data = [
                'unique_query_id'   =>$lead['UNIQUE_QUERY_ID']??'',
                'query_type'        =>$lead['QUERY_TYPE']??'',
                'sender_name'       => $lead['SENDER_NAME'] ?? '',
                'sender_mobile'     => $lead['SENDER_MOBILE'] ?? '',
                'sender_email'      => $lead['SENDER_EMAIL'] ?? '',
                'subject'           => $lead['SUBJECT'] ??'',
                'sender_company'    => $lead['SENDER_COMPANY'] ??'',
                'sender_address'    => $lead['SENDER_ADDRESS'] ??'',
                'sender_city'       => $lead['SENDER_CITY'] ??'',
                'sender_state'      => $lead['SENDER_STATE'] ??'',
                'sender_pincode'    => $lead['SENDER_PINCODE'] ??'',
                'sender_country_iso'=> $lead['SENDER_COUNTRY_ISO'] ??'',
                'sender_mobile_alt' => $lead['SENDER_MOBILE_ALT'] ??'',
                'query_prd_name'    => $lead['QUERY_PRODUCT_NAME'] ?? '',
                'query_message'     => $lead['QUERY_MESSAGE'],
                'call_duration'     => $lead['CALL_DURATION'] ?? '',
                'lead_source'       => 'IndiaMART',
                'query_time'        => date('Y-m-d H:i:s', strtotime($lead['QUERY_TIME'] ?? 'now')),
                'sms_sent'          => 0, // initially not sent
            ];
            log_message('debug', 'Parsed Lead #' . ($index + 1) . ': ' . print_r($data, true));
            // Avoid duplicate leads based on mobile number
            if (!$model->where('unique_query_id', $data['unique_query_id'])->first()) {
                $insertedId = $model->insert($data);
        
                // If inserted successfully, send SMS
                if ($insertedId) {
                    // Compose SMS
                    $smsMessage = "Hi " . $data['sender_name'] . ".Check New Message from Kaypee.. We Will Contact You Soon";
                    $mob = '+917803806833';
                    $smsSent = $smsService->sendSMS($mob, $smsMessage);

                    // Update sms_sent flag
                    if ($smsSent) {
                        $model->update($insertedId, ['sms_sent' => 1]);
                        log_message('info', 'SMS sent to ' . $mob);
                    } else {
                        log_message('error', 'SMS failed for ' . $mob);
                    }
                }

                $leads[] = $data;
                    }
        }

        // 8. Return success response
        return $this->respond([
            'status'  => 1,
            'total_records' => count($leads),
            'message' => 'IndiaMART leads fetched successfully',
            'data'    => $leads
        ]);
    }
}
