<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateUsersTable extends Migration
{
    public function up()
    {
        // Users Table
        $this->forge->addField([
            'userid'     => ['type' => 'INT', 'constraint' => 11, 'auto_increment' => true],
            'first_name'  => ['type' => 'VARCHAR', 'constraint' => 100],
            'last_name'   => ['type' => 'VARCHAR', 'constraint' => 100],
            'email'       => ['type' => 'VARCHAR', 'constraint' => 100, 'unique' => true],
            'phone'       => ['type' => 'VARCHAR', 'constraint' => 100, 'unique' => true],
            'user_status' => ['type' => 'INT', 'constraint' => 11],
            'password'    => ['type' => 'VARCHAR', 'constraint' => 255],
            'created_at'  => ['type' => 'DATETIME', 'null' => true],
            'updated_at'  => ['type' => 'DATETIME', 'null' => true],
        ]);
        $this->forge->addKey('userid', true);
        $this->forge->createTable('kp_users');

        // Roles Table
        $this->forge->addField([
            'id'   => ['type' => 'INT', 'constraint' => 11, 'auto_increment' => true],
            'name' => ['type' => 'VARCHAR', 'constraint' => 50],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('kp_roles');

        // Permissions Table
        $this->forge->addField([
            'id'   => ['type' => 'INT', 'constraint' => 11, 'auto_increment' => true],
            'name' => ['type' => 'VARCHAR', 'constraint' => 50],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('kp_permissions');

        // Role Permissions Table (Many-to-Many)
        $this->forge->addField([
            'role_id'       => ['type' => 'INT', 'constraint' => 11],
            'permission_id' => ['type' => 'INT', 'constraint' => 11],
        ]);
        $this->forge->createTable('kp_role_permissions');

        // User Roles Table (Many-to-Many)
        $this->forge->addField([
            'user_id' => ['type' => 'INT', 'constraint' => 11],
            'role_id' => ['type' => 'INT', 'constraint' => 11],
        ]);
        $this->forge->createTable('kp_user_roles');
    }

    public function down()
    {
        $this->forge->dropTable('kp_users');
        $this->forge->dropTable('kp_roles');
        $this->forge->dropTable('kp_permissions');
        $this->forge->dropTable('kp_role_permissions');
        $this->forge->dropTable('kp_user_roles');
    }
}
