<?php

namespace App\Libraries;

class Paginator
{
    public function paginate($model, $filters = [], $search = null, $searchFields = [], $page = 1, $limit = 10)
    {
        $offset = ($page - 1) * $limit;

        
        if (!empty($filters)) {
            $model->where($filters);
        }

    
        if ($search && !empty($searchFields)) {
            $model->groupStart();
            foreach ($searchFields as $field) {
                $model->orLike($field, $search);
            }
            $model->groupEnd();
        }

        
        $total = $model->countAllResults(false);

    
        $results = $model->limit($limit, $offset)->find();

        return [
            'total' => $total,
            'page' => $page,
            'limit' => $limit,
            'data' => $results
        ];
    }
}
